package org.mintsoft.mintly.sdkoffers;

import android.app.Dialog;
import android.content.Intent;
import android.os.Bundle;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.chartboost.sdk.Chartboost;
import com.chartboost.sdk.ads.Rewarded;
import com.chartboost.sdk.callbacks.RewardedCallback;
import com.chartboost.sdk.events.CacheError;
import com.chartboost.sdk.events.CacheEvent;
import com.chartboost.sdk.events.ClickError;
import com.chartboost.sdk.events.ClickEvent;
import com.chartboost.sdk.events.DismissEvent;
import com.chartboost.sdk.events.ImpressionEvent;
import com.chartboost.sdk.events.RewardEvent;
import com.chartboost.sdk.events.ShowError;
import com.chartboost.sdk.events.ShowEvent;

import org.mintsoft.mintlib.DataParse;
import org.mintsoft.mintlib.GetURL;
import org.mintsoft.mintlib.Offerwalls;
import org.mintsoft.mintlib.onResponse;
import org.mintsoft.mintly.Home;
import org.mintsoft.mintly.helper.AppCompat;
import org.mintsoft.mintly.helper.Misc;

import java.util.HashMap;

public class chartboost extends AppCompat {
    private Dialog dialog;
    private HashMap<String, String> data;
    private boolean isLive;
    private Rewarded rewardedAds;

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        isLive = true;
        Intent intent = getIntent();
        data = Misc.convertToHashMap(intent, "info");
        if (data != null) {
            dialog = Misc.loadingDiagExit(this);
            dialog.show();
            Offerwalls.getStat(this, "chartboost", true, new onResponse() {
                @Override
                public void onSuccess(String s) {
                    if (!isLive) return;
                    if (s.equals("1")) {
                        runOnUiThread(() -> forward());
                    } else {
                        Toast.makeText(chartboost.this, DataParse.getStr(chartboost.this,
                                "exceed_daily_limit", Home.spf), Toast.LENGTH_LONG).show();
                        finish();
                    }
                }

                @Override
                public void onError(int i, String s) {
                    if (!isLive) return;
                    dialog.dismiss();
                    Toast.makeText(chartboost.this, s, Toast.LENGTH_LONG).show();
                    finish();
                }
            });
        } else {
            finish();
        }
    }

    private void forward() {
        Chartboost.startWithAppId(this, data.get("app_id"), data.get("app_signature"), startError -> {
            if (startError == null) {
                rewardedAds = new Rewarded("CustomLocation", new RewardedCallback() {
                    @Override
                    public void onRewardEarned(@NonNull RewardEvent rewardEvent) {
                        if (!isLive) return;
                        GetURL.info(chartboost.this, "chartboost/er?a=" + rewardEvent.getReward(), true, new onResponse() {
                            @Override
                            public void onSuccess(String s) {
                            }
                        });
                    }

                    @Override
                    public void onAdDismiss(@NonNull DismissEvent dismissEvent) {
                        if (!isLive) return;
                        if (dialog.isShowing()) dialog.dismiss();
                        finish();
                    }

                    @Override
                    public void onAdLoaded(@NonNull CacheEvent cacheEvent, @Nullable CacheError cacheError) {
                        rewardedAds.show();
                    }

                    @Override
                    public void onAdRequestedToShow(@NonNull ShowEvent showEvent) {

                    }

                    @Override
                    public void onAdShown(@NonNull ShowEvent showEvent, @Nullable ShowError showError) {
                        if (!isLive) return;
                        finish();
                    }

                    @Override
                    public void onAdClicked(@NonNull ClickEvent clickEvent, @Nullable ClickError clickError) {

                    }

                    @Override
                    public void onImpressionRecorded(@NonNull ImpressionEvent impressionEvent) {

                    }
                }, null);
                rewardedAds.cache();
            } else {
                uiToast("" + startError.getException());
                finish();
            }
        });
    }

    private void uiToast(final String toast) {
        runOnUiThread(() -> Toast.makeText(chartboost.this, toast, Toast.LENGTH_LONG).show());
    }

    @Override
    protected void onDestroy() {
        isLive = false;
        if (dialog.isShowing()) dialog.dismiss();
        super.onDestroy();
    }
}